//
//  MCFormatterManager.h
//  MCFoundation
//
//  Created by Ali Lalani on 08/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

/*
 Code 29 is reserved for custom date format
 Code 59 is reserved for custom number format
 Code 89 is reserved for custom array flatten format
 Code 90 is reserved for formatter from object that responds to 'currencyFormatter'
 Code 91 is reserved for formatter from keypath
 */
typedef enum { 
	MCShortDateFormatCode = 10, 
	MCMediumDateFormatCode = 11, 
	MCLongDateFormatCode = 12, 
	MCAMPMTimeFormatCode = 13, 
	MC24HTimeFormatCode = 14, 
	MCShortDateTimeFormatCode = 15, 
	MCLongDateTimeFormatCode = 18, 
	MC2DecimalCurrencyFormatCode = 30, 
	MC3DecimalCurrencyFormatCode = 31, 
	MCNoDecimalCurrencyFormatCode = 32, 
	MC2DecimalCurrencyWithTildeFormatCode = 33, 
	MCHourMinuteDurationFormatCode = 40, 
	MCMinuteSecondDurationFormatCode = 41, 
	MCHourMinuteSecondDurationFormatCode = 42, 
	MCNaturalLanguageDurationFormatCode  = 43,
	MCDecimalTimeDurationFormatCode  = 44,
	MCNoDecimalPercentageFormatCode = 50, 
	MC2DecimalPercentageFormatCode = 51, 
	MC3DecimalPercentageFormatCode = 52,
	MCArrayFlattenAutomaticFormatCode = 80
} MCFormatCode;



@interface MCFormatterManager : NSObject {
	NSMutableDictionary *_formatters;
	NSMutableDictionary *_formattersForCode;
    NSTimeZone *timeZone;
}

@property (nonatomic, retain) NSTimeZone *timeZone;

+ (MCFormatterManager *)defaultManager;

// provides a default set of formatters unless you override with the setFormatter:forCode:
- (id)formatterForFormatCode:(MCFormatCode)aCode;
- (void)setFormatter:(id)aFormatter forCode:(MCFormatCode)aCode;


- (id)formatterForClassname:(NSString *)classname formatString:(NSString *)formatString;
- (id)createFormatterForClassname:(NSString *)classname formatString:(NSString *)formatString;


- (NSMutableDictionary *)formatters;
- (void)setFormatters:(NSMutableDictionary *)aFormatters;

/*!
 Replaces the currency formatter for MC2DecimalCurrencyFormatCode, MC3DecimalCurrencyFormatCode & MCNoDecimalCurrencyFormatCode with post 10.4 variants on NSNumberFormatter. MCFormatCodes are mostly used in the ReportEngine
 */
- (void)replaceCurrencyFormattersToModernFormattersWithLocale:(NSLocale *)aLocale 
														 code:(NSString *)currencyCode 
													   symbol:(NSString *)symbol;

@end
